package com.mmc.csf.release.controller.licence;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.licence.dto.LicenseOrganizationsDTO;
import com.mmc.csf.licence.qo.LicenseOrganizationsQO;
import com.mmc.csf.licence.vo.LicenseOrganizationsVO;
import com.mmc.csf.release.controller.BaseController;
import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Page;
import com.mmc.csf.release.model.group.Update;
import com.mmc.csf.release.service.licence.LicenceBackgroundService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author small
 * @Date 2023/7/13 16:00
 * @Version 1.0
 */
@Api(tags = {"执照——后台管理"})
@RestController
@RequestMapping("/licence/background")
public class LicenceBackgroundController extends BaseController {

    @Autowired
    private LicenceBackgroundService licenceBackgroundService;

    @ApiOperation(value = "机构-上传")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/insertOrg")
    public ResultBody insertOrganizations(HttpServletRequest request, @RequestBody @Validated(value = {Create.class}) LicenseOrganizationsVO organizations) {
        return licenceBackgroundService.insertOrganizations(organizations, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "机构-修改")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/updateOrg")
    public ResultBody updateOrganizations(HttpServletRequest request, @RequestBody @Validated(value = {Update.class}) LicenseOrganizationsVO organizations) {
        return licenceBackgroundService.updateOrganizations(organizations, this.getUserLoginInfoFromRedis(request));
    }


    @ApiOperation(value = "机构-删除")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/removeOrg")
    public ResultBody removeOrganizations(@ApiParam(value = "机构id", required = true) @RequestParam Integer id) {
        return licenceBackgroundService.removeOrganizations(id);
    }


    @ApiOperation(value = "机构列表-分页")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LicenseOrganizationsDTO.class)})
    @PostMapping("/listOrgPage")
    public ResultBody<LicenseOrganizationsDTO> listOrgPage(HttpServletRequest request,
                                                           @Validated(value = {Page.class}) @ApiParam(value = "角色查询QO", required = true) @RequestBody LicenseOrganizationsQO organizationsQO) {
        return ResultBody.success(licenceBackgroundService.listOrgPage(organizationsQO, this.getUserLoginInfoFromRedis(request)));
    }


    @ApiOperation(value = "app机构列表-分页")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LicenseOrganizationsDTO.class)})
    @PostMapping("/appListOrgPage")
    public ResultBody<LicenseOrganizationsDTO> appListOrgPage(HttpServletRequest request,
                                                              @Validated(value = {Page.class}) @ApiParam(value = "角色查询QO", required = true) @RequestBody LicenseOrganizationsQO organizationsQO) {
        return ResultBody.success(licenceBackgroundService.listOrgPage(organizationsQO, this.getUserLoginInfoFromRedis(request)));
    }


    @ApiOperation(value = "web机构列表-分页")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LicenseOrganizationsDTO.class)})
    @PostMapping("/webListOrgPage")
    public ResultBody<LicenseOrganizationsDTO> webListOrgPage(HttpServletRequest request,
                                                              @Validated(value = {Page.class}) @ApiParam(value = "角色查询QO", required = true) @RequestBody LicenseOrganizationsQO organizationsQO) {
        return ResultBody.success(licenceBackgroundService.listOrgPage(organizationsQO, this.getUserLoginInfoFromRedis(request)));
    }

    
}
