package com.mmc.csf.release.controller.licence;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.licence.dto.LicenceGradeDTO;
import com.mmc.csf.licence.dto.LicenceModelsDTO;
import com.mmc.csf.licence.dto.LicenceScaleDTO;
import com.mmc.csf.licence.dto.LicenceTypeDTO;
import com.mmc.csf.release.service.licence.LicenceCommonService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author small
 * @Date 2023/7/13 14:32
 * @Version 1.0
 */
@Api(tags = {"执照——公共下拉列表"})
@RestController
@RequestMapping("/licence/pullDown")
public class LicenceCommonController {

    @Autowired
    private LicenceCommonService licenceCommonService;

    @ApiOperation(value = "公共——执照等级")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LicenceGradeDTO.class)})
    @GetMapping("/licenceGradeList")
    public ResultBody<LicenceGradeDTO> licenceGradeList() {
        return licenceCommonService.licenceGradeList();
    }

    @ApiOperation(value = "公共——执照机型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LicenceModelsDTO.class)})
    @GetMapping("/licenceModelsList")
    public ResultBody<LicenceModelsDTO> licenceModelsList() {
        return licenceCommonService.licenceModelsList();
    }


    @ApiOperation(value = "公共——执照类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LicenceModelsDTO.class)})
    @GetMapping("/licenceTypeList")

    public ResultBody<LicenceTypeDTO> licenceTypeList() {
        return licenceCommonService.licenceTypeList();
    }


    @ApiOperation(value = "不是公共——新增执照机构规模id")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LicenceScaleDTO.class)})
    @GetMapping("/licenceScaleList")
    public ResultBody<LicenceScaleDTO> licenceScaleList() {
        return licenceCommonService.licenceScaleList();
    }
}
