package com.mmc.csf.user.vo;

import com.alibaba.fastjson2.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang.StringUtils;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/5/23 19:24
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class WxMsgVO implements Serializable {
    private static final long serialVersionUID = 107288179600606045L;
    @ApiModelProperty(value = "用户id-仅适用云享飞客户端")
    private Integer userAccountId;
    @ApiModelProperty(value = "公众号的openId")
    private String touser;
    @ApiModelProperty(value = "unionId-全局通用")
    private String unionId;
    @ApiModelProperty(value = "模板id")
    @NotNull(message = "模板id不能为空")
    private String templateId;
    @ApiModelProperty(value = "网页跳转连接")
    private String url;
    @ApiModelProperty(value = "小程序APPID")
    private String wxAppletAppId;
    @ApiModelProperty(value = "小程序跳转连接")
    private String appletPath;
    @ApiModelProperty(value = "按照接口文档传数据")
    private JSONObject dataObject;

    public String buildTemplateMsg() {
        JSONObject msg = new JSONObject();
        msg.put("touser", this.touser);
        msg.put("template_id", this.templateId);
        // 跳转页面
        if (!StringUtils.isBlank(this.url)) {
            msg.put("url", this.url);
        }
        // 跳转小程序页面设置
        if (!StringUtils.isBlank(this.wxAppletAppId) && !StringUtils.isBlank(this.appletPath)) {
            JSONObject mini = new JSONObject();
            mini.put("appid", this.wxAppletAppId);
            mini.put("pagepath", this.appletPath);
            msg.put("miniprogram", mini);
        }
        msg.put("data", this.dataObject);
        return msg.toString();
    }
}
