package com.mmc.csf.infomation.vo;

import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Others;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class IndustryNewsVO implements Serializable {

    private static final long serialVersionUID = 8479619142765659138L;

    @ApiModelProperty(value = "id")
    @NotNull(message = "修改id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "新闻标题",example = "新闻标题")
    @NotBlank(message = "文章标题不能为空",groups = {Create.class,Update.class})
    private String newsTitle;

    @ApiModelProperty(value = "作者",example = "作者")
    @NotBlank(message = "作者不能为空",groups = {Create.class,Update.class})
    private String newsAuthor;

    @ApiModelProperty(value = "创建人",hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "封面图")
    @NotBlank(message = "封面图不能为空",groups = {Create.class,Update.class})
    private String surfaceImg;

    @ApiModelProperty(value = "新闻内容")
    private String newsContents;

    @ApiModelProperty(value = "来源",example = "来源")
    private String origin;

    @ApiModelProperty(value = "是否是热点新闻 1是 0不是")
    private Integer isHot;
}
