package com.mmc.csf.infomation.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mmc.csf.config.IsNullConvertZero;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/19 16:11
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class GetOrderNumberDTO implements Serializable {

    @ApiModelProperty(hidden = true)
    @JsonIgnore
    private Integer id;

    private static final long serialVersionUID = 75097833899496576L;
    @ApiModelProperty(value = "支付订单编号", example = "dadasdas")
    private String paymentOrderNumber;

    @ApiModelProperty(value = "微信需要支付金额", example = "100")
    @IsNullConvertZero
    private BigDecimal weChatPay;

    @JsonIgnore
    @ApiModelProperty(value = "用户id", example = "100", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "服务id")
    private Integer requirementsInfoId;


}
