package com.mmc.csf.release.service.data.impl;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.data.dto.ReleaseReportDTO;
import com.mmc.csf.release.dao.DynamicDao;
import com.mmc.csf.release.dao.RequirementsDao;
import com.mmc.csf.release.dao.TenderDao;
import com.mmc.csf.release.service.data.ReleaseReportService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;

/**
 * @Author LW
 * @date 2023/9/18 10:44
 * 概要：
 */
@Service
public class ReleaseReportServiceImpl implements ReleaseReportService {
    @Resource
    private RequirementsDao requirementsDao;
    @Resource
    private DynamicDao dynamicDao;
    @Resource
    private TenderDao tenderDao;

    @Override
    public ResultBody<ReleaseReportDTO> getReleaseReportData() {
        ReleaseReportDTO releaseReportDTO = new ReleaseReportDTO();
        // 获取订单发布数量总数
        int orderCount = requirementsDao.getOrderReleaseCount();
        releaseReportDTO.setOrderReleaseCount(orderCount);
        // 获取帖子发布总数
        int dynamicCount = dynamicDao.getDynamicCount();
        releaseReportDTO.setPostsReleaseCount(dynamicCount);
        // 获取话题发布总数
        int gambitReleaseCount = dynamicDao.getGambitReleaseCount();
        releaseReportDTO.setTopicReleaseCount(gambitReleaseCount);
        // 获取新闻发布总数
        int newsReleaseCount = tenderDao.getNewsReleaseCount();
        releaseReportDTO.setNewsReleaseCount(newsReleaseCount);
        // 获取招标信息总数
        int tenderReleaseCount = tenderDao.getTenderReleaseCount();
        releaseReportDTO.setTenderReleaseCount(tenderReleaseCount);
        // 信息发布总数
        releaseReportDTO.setReleaseCount(orderCount + dynamicCount + gambitReleaseCount + newsReleaseCount + tenderReleaseCount);
        // 获取订单金额
        BigDecimal serviceOrderAmount = requirementsDao.getServiceOrderAmount();
        releaseReportDTO.setServiceOrderAmount(serviceOrderAmount);
        return ResultBody.success(releaseReportDTO);
    }
}
