package com.mmc.csf.release.entity.store;

import com.mmc.csf.web.dto.MaintainDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * (MaintainDO)实体类
 *
 * @author makejava
 * @since 2023-06-10 21:42:42
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MaintainDO implements Serializable {
  private static final long serialVersionUID = -53401640557659711L;

  private Integer id;

  private String name;

  private String address;

  private Double lon;

  private Double lat;

  private Double distance;

  public MaintainDTO buildMaintainDTO() {
    this.distance =
        this.distance == null
            ? 0
            : (BigDecimal.valueOf(this.distance).setScale(2, BigDecimal.ROUND_HALF_DOWN))
                .doubleValue();
    return MaintainDTO.builder()
        .name(name)
        .address(address)
        .lon(this.lon)
        .lat(this.lat)
        .distance(this.distance / 1000)
        .build();
  }
}
