package com.mmc.csf.release.entity.curriculum;

import com.mmc.csf.release.flyer.vo.CurriculumInfoVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.io.Serializable;

/**
 * 课程基本信息(CurriculumInfoDO)实体类
 *
 * @author makejava
 * @since 2023-05-18 17:37:06
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CurriculumInfoDO implements Serializable {
    private static final long serialVersionUID = 140348746605431718L;
    
    private Integer id;

    /**
     * 1级课程分类ID
     */
    private Integer oneCourseId;
    /**
     * 2级课程分类ID
     */
    private Integer twoCourseId;
    /**
     * 课程名称
     */
    private String curriculumName;
    /**
     * 课程简介
     */
    private String curriculumDesc;
    /**
     * 课程封面
     */
    private String surfaceUrl;
    /**
     * 课程视频
     */
    private String videoUrl;
    /**
     * 课程属性
     */
    private Integer courseAttribute;
    /**
     * 课程所需金额
     */
    private BigDecimal requireAmout;
    /**
     * 课程所需积分
     */
    private Integer requireIntegral;
    /**
     * 课程是否热门 0：否 1：是
     */
    private Integer isHot;
    /**
     * 课程详情
     */
    private String detailContent;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
    /**
     * 是否删除 0：否 1：是
     */
    private Integer deleted;


    public CurriculumInfoDO(CurriculumInfoVO curriculumInfoVO) {
        this.id = curriculumInfoVO.getId();
        this.oneCourseId = curriculumInfoVO.getOneCourseId();
        this.twoCourseId = curriculumInfoVO.getTwoCourseId();
        this.curriculumName = curriculumInfoVO.getCurriculumName();
        this.curriculumDesc = curriculumInfoVO.getCurriculumDesc();
        this.surfaceUrl = curriculumInfoVO.getSurfaceUrl();
        this.videoUrl = curriculumInfoVO.getVideoUrl();
        this.courseAttribute = curriculumInfoVO.getCourseAttribute();
        this.requireAmout = curriculumInfoVO.getRequireAmout();
        this.requireIntegral = curriculumInfoVO.getRequireIntegral();
        this.isHot = curriculumInfoVO.getIsHot();
        this.detailContent = curriculumInfoVO.getDetailContent();
    }

    public CurriculumInfoVO buildCurriculumInfoVO(){
        return CurriculumInfoVO.builder().id(id).curriculumDesc(curriculumDesc)
                .curriculumName(curriculumName)
                .videoUrl(videoUrl).surfaceUrl(this.surfaceUrl).detailContent(this.detailContent)
                .requireAmout(this.requireAmout).courseAttribute(courseAttribute)
                .requireIntegral(this.requireIntegral).isHot(this.isHot)
                .oneCourseId(this.oneCourseId).twoCourseId(this.twoCourseId)
                .createTime(createTime).updateTime(updateTime).build();
    }

}

