package com.mmc.csf.release.industry;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/8/18 13:39
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class IndustryTypeDTO implements Serializable {
    private static final long serialVersionUID = -5832618357203415274L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "行业类型名称")
    private String typeName;
    @ApiModelProperty(value = "行业图标")
    private String typeImg;
    @ApiModelProperty(value = "行业描述")
    private String description;
    @ApiModelProperty(value = "售卖状态，0停售，1在售")
    private Integer saleState;
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    @ApiModelProperty(value = "服务列表")
    private List<InspectionDTO> inspectionDTOS;
    @ApiModelProperty(value = "二级分类名称")
    private String inspectionName;
}
