package com.mmc.csf.release.flyer.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author han
 * 概要:课程分类
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CurriculumClassifyVO implements Serializable {
    private static final long serialVersionUID = -7343885960160805850L;

    @ApiModelProperty(value = "课程分类id")
    private Integer id;

    @ApiModelProperty(value = "分类名字")
    @NotNull(message = "分类名字不能为空" ,groups = {Update.class})
    private String name;

    @ApiModelProperty(value = "1级课程分类")
    private Integer oneCourseId;

    @ApiModelProperty(value = "2级课程分类")
    private Integer twoCourseId;

    @ApiModelProperty(value = "分类图标")
    private String classifyUrl;

    @ApiModelProperty(value = "分类描述")
    private String classifyDesc;

    @ApiModelProperty(value = "创建时间")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

}
