package com.mmc.csf.infomation.vo;

import com.mmc.csf.config.IsNullConvertZero;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/23 9:43
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PublisherWalletFlowVO {

    @ApiModelProperty(value = "用户ID")
    @NotNull
    private Integer userAccountId;

    @ApiModelProperty(value = "支付方式 100（订单发布） 200(无人接单取消订单）300（有人接单取消订单）400（飞手抢单）500（客服判定飞手无责取消订单）" +
            "600（飞手有责取消订单）700（正常结算）800(修改订单金额状态)900（飞手未确认修改金额状态）1000（飞手确认修改金额状态）")
    private Integer modeOfPayment;

    @ApiModelProperty(value = "云享金（需要正负）注：结算时修改金额如果大于原订单，需要支付的云享金，也传这个字段")
    @IsNullConvertZero
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "佣金（需要正负）注：结算时修改金额如果大于原订单，需要支付的佣金，也传这个字段")
    @IsNullConvertZero
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "支付时间")
    private Date timeOfPayment;

    @ApiModelProperty(value = "操作者用户id")
    @NotNull
    private Integer operateUserAccountId;

    @ApiModelProperty(value = "云享金违约金（需要正负）")
    @IsNullConvertZero
    private BigDecimal yxjCashPledge;

    @ApiModelProperty(value = "佣金违约金（需要正负）")
    @IsNullConvertZero
    private BigDecimal salaryCashPledge;

    @ApiModelProperty(value = "订单的百分比违约金(这笔钱是给飞手的) （需要正负）")
    @IsNullConvertZero
    private BigDecimal percentagePenaltyOfOrder;

    @ApiModelProperty(value = "加急单云享金金额 （需要正负）")
    @IsNullConvertZero
    private BigDecimal urgentYxjAmount;

    @ApiModelProperty(value = "加急单佣金金额 （需要正负）")
    @IsNullConvertZero
    private BigDecimal urgentSalaryAmount;

    @ApiModelProperty(value = "置顶单云享金金额 （需要正负）")
    @IsNullConvertZero
    private BigDecimal topYxjAmount;

    @ApiModelProperty(value = "置顶单佣金金额 （需要正负）")
    @IsNullConvertZero
    private BigDecimal topSalaryAmount;

    @ApiModelProperty(value = "飞手应得订单金额 （正数）")
    @IsNullConvertZero
    private BigDecimal flyerSalaryAmount;

    @ApiModelProperty(value = "修改后金额（注：①飞手未确认时，后面支付的需要退的佣金那部分钱 ②飞手确认时，修改后的金额小于原佣金，需要退多余的佣金那部分钱 ③如果全部是微信支付的则不用传值）")
    @IsNullConvertZero
    private BigDecimal refundSalaryAmount;

    @ApiModelProperty(value = "修改后金额（注：①飞手未确认时，后面支付的需要退的云享金那部分钱 ②飞手确认时，修改后的金额小于原佣金，需要退多余的云享金那部分钱 ③如果全部是微信支付的则不用传值）")
    @IsNullConvertZero
    private BigDecimal refundCashAmount;

}
