package com.mmc.csf.common.util.page;

import java.io.Serializable;

import com.mmc.csf.release.flyer.qo.BaseInfoQO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author 作者 geDuo
 * @version 创建时间：2021年8月28日 下午3:18:21
 * @explain 分页工具类
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PageResult<T> implements Serializable{
	private static final long serialVersionUID = -2848996493573325801L;
	private int pageNo;// 分页起始页
	private int pageSize;// 每页记录数
	private T list;// 返回的记录集合
	private long totalCount;// 总记录条数
	private long totalPage;// 总页数

	public static PageResult buildPage(int pageNo, int pageSize, int totalCount) {
		PageResult page = new PageResult();
		page.pageNo = pageNo;
		page.pageSize = pageSize;
		page.totalCount = totalCount;
		page.totalPage = (totalCount % pageSize == 0) ? (totalCount / pageSize) : (totalCount / pageSize + 1);
		return page;
	}

	public static <T> PageResult buildPage(int pageNo, int pageSize, int totalCount, T list) {
		PageResult page = PageResult.buildPage(pageNo, pageSize, totalCount);
		page.setList(list);
		return page;
	}

	public static PageResult buildPage(BaseInfoQO qo, int totalCount) {
		PageResult page = new PageResult();
		page.pageNo = qo.getPageNo();
		Integer pageSize = qo.getPageSize();
		page.pageSize = pageSize;
		page.totalCount = totalCount;
		page.totalPage = (totalCount % pageSize == 0) ? (totalCount / pageSize) : (totalCount / pageSize + 1);
		return page;
	}
}
