package com.mmc.csf.release.entity.information;

import com.mmc.csf.infomation.vo.IndustryNewsDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @description 行业新闻
 * @author: zj
 * @Date: 2023/5/19 11:20
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class IndustryNewsDO implements Serializable {
    private static final long serialVersionUID = 3296973167970903480L;
    private Integer id;
    private String newsTitle;
    private String newsAuthor;
    private Integer userAccountId;
    private String surfaceImg;
    private String newsContents;
    private Date createTime;
    private Date updateTime;
    @ApiModelProperty(value = "来源")
    private String origin;
    private Integer isDeleted;

    public IndustryNewsDTO buildIndustryNewsDTO(){
        return IndustryNewsDTO.builder().id(id).newsTitle(newsTitle).newsAuthor(newsAuthor).userAccountId(userAccountId).surfaceImg(surfaceImg).
                newsContents(newsContents).createTime(createTime).updateTime(updateTime).origin(origin).build();
    }

    public IndustryNewsDO(Integer id, String newsTitle, String newsAuthor, Integer userAccountId, String surfaceImg, String newsContents, String origin) {
        this.id = id;
        this.newsTitle = newsTitle;
        this.newsAuthor = newsAuthor;
        this.userAccountId = userAccountId;
        this.surfaceImg = surfaceImg;
        this.newsContents = newsContents;
        this.origin = origin;
    }
}
