package com.mmc.csf.release.entity.forum;

import java.io.Serializable;

import com.mmc.csf.release.entity.common.BaseDO;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 评论表(ForumCommentDO)实体类
 *
 * @author lw
 * @since 2023-05-16 09:54:25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ForumCommentDO extends BaseDO implements Serializable {
  private static final long serialVersionUID = 768897358613182410L;
  private Integer userAccountId;
  /** 动态id，外键，关联dynamic表 */
  private Integer dynamicId;
  /** 评论内容 */
  private String content;
  /** 点赞数量 */
  private Integer likesCount;
}
