package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.IndustryCaseVO;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Page;
import com.mmc.csf.release.model.group.Update;
import com.mmc.csf.release.service.IndustryCaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/19 11:34
 */
@Api(tags = {"业务案例相关"})
@RestController
@RequestMapping("/industry-case/")
public class IndustryCaseController extends BaseController{
    @Autowired
    private IndustryCaseService industryCaseService;

    @ApiOperation(value = "案例列表")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = IndustryCaseVO.class) })
    @PostMapping("listCasePage")
    public ResultBody listCasePage(@Validated(value = {Page.class})@RequestBody IndustryCaseQO industryCaseQO, HttpServletRequest request){
        return industryCaseService.listCasePage(industryCaseQO, request);
    }

    @ApiOperation(value = "案例详情")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = IndustryCaseVO.class) })
    @GetMapping("details")
    public ResultBody details(@RequestParam Integer id){
        return industryCaseService.details(id);
    }

    @ApiOperation(value = "添加业务案例")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = IndustryCaseVO.class) })
    @PostMapping("addCase")
    public ResultBody addCase(@Validated(value = {Insert.class})@RequestBody IndustryCaseVO industryCaseVO, HttpServletRequest request){
        return industryCaseService.addCase(industryCaseVO, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "修改业务案例")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = IndustryCaseVO.class) })
    @PostMapping("updateCase")
    public ResultBody updateCase(@Validated(value = {Update.class})@RequestBody IndustryCaseVO industryCaseVO, HttpServletRequest request){
        return industryCaseService.updateCase(industryCaseVO, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "删除业务案例")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = IndustryCaseVO.class) })
    @GetMapping("deleteDetails")
    public ResultBody deleteDetails(@RequestParam Integer id){
        return industryCaseService.deleteDetails(id);
    }
}
