package com.mmc.csf.licence.dto;

import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/7/14 16:51
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LicenseOrganizationsDTO {

    private static final long serialVersionUID = -5814724843819090363L;
    @ApiModelProperty(value = "机构id", example = "1")
    @NotNull(message = "机构id", groups = Update.class)
    private Integer id;

    @ApiModelProperty(value = "机构主图不能为空", example = "http://", required = true)
    @NotBlank(message = "机构主图不能为空", groups = {Create.class, Update.class})
    private String mainImage;

    @ApiModelProperty(value = "机构副图不能为空", example = "http://", required = true)
    @NotBlank(message = "机构副图不能为空", groups = {Create.class, Update.class})
    private String auxiliaryPicture;

    @ApiModelProperty(value = "机构视频", example = "http://")
    private String video;

    @ApiModelProperty(value = "机构名称不能为空", example = "科比特智能教育", required = true)
    @NotBlank(message = "机构名称不能为空", groups = {Create.class, Update.class})
    @Size(max = 25, message = "机构名称不能超过25个字符")
    private String name;

    @ApiModelProperty(value = "机构地区", example = "110000,110100")
    @NotBlank(message = "机构地区不能为空", groups = {Create.class, Update.class})
    private String region;

    @ApiModelProperty(value = "机构地区名称", example = "河北省,石家庄市", required = true)
    @NotBlank(message = "机构地区名称", groups = {Create.class, Update.class})
    private String regionName;

    @ApiModelProperty(value = "机构详细地址", example = "南山区")
    @NotBlank(message = "机构详细地址不能为空", groups = {Create.class, Update.class})
    private String detailedAddress;

    @ApiModelProperty(value = "是否是考点机构 0否 1是", example = "0", required = true)
    @NotNull(message = "考点机构不能为空", groups = {Create.class, Update.class})
    private Integer testCenter;

    @ApiModelProperty(value = "机构规模id不能为空 ", example = "1")
    //@NotNull(message = "机构规模id不能为空", groups = {Create.class, Update.class})
    private Integer scaleId;

    @ApiModelProperty(value = "机构规模名称", example = "1")
    private String scaleName;

    @ApiModelProperty(value = "机构描述", example = "机构描述0001")
    //@NotNull(message = "机构描述", groups = {Create.class, Update.class})
    private String description;

    @ApiModelProperty(value = "机构详情", example = "机构详情0001")
    //@NotNull(message = "机构描述", groups = {Create.class, Update.class})
    private String detail;

    @ApiModelProperty(value = "培训项目", required = false)
    private List<LicenseTrainingProgramsDTO> programsDOList;


    @ApiModelProperty(value = "经度", example = "40.892313123", required = true)
    private Double longitude;

    @ApiModelProperty(value = "纬度", example = "50.892313123", required = true)
    private Double latitude;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间", example = "2023-07-14", required = true)
    private Date createTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新时间", example = "2023-07-14", required = true)
    private Date updateTime;

}
