package com.mmc.csf.infomation.qo;

import com.mmc.csf.release.model.group.Page;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/23 14:21
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.qo.ModuleInfoQO", description = "宣传中心模块查询QO")
public class ModuleInfoQO implements Serializable {
    private static final long serialVersionUID = -681758664049977685L;
    @ApiModelProperty(value = "模块名称")
    private String moduleName;
    @ApiModelProperty(value = "所属产品",hidden = true)
    private Integer moduleType;
    @ApiModelProperty(value = "模块代码")
    private String moduleCode;
    @ApiModelProperty(value = "port:0云享飞，1无人机城",hidden = true)
    private Integer port;
    @ApiModelProperty(value = "页码", required = true,example = "1")
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;
    @ApiModelProperty(value = "每页显示数", required = true,example = "10")
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }

}
