package com.mmc.csf.release.entity;

import com.mmc.csf.release.task.vo.OrderTaskVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.io.Serializable;

/**
 * 任务订单做
 * (TaskOrderDO)实体类
 *
 * @author makejava
 * @date 2023/05/18
 * @since 2023-05-18 10:58:17
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TaskOrderDO implements Serializable {
    private static final long serialVersionUID = 174802281244031352L;
    
    private Integer id;
    /**
     * 订单编号
     */
    private String orderNo;
    /**
     * 订单名称
     */
    private String orderName;
    /**
     * 服务id
     */
    private Integer inspectionId;
    /**
     * 开始时间
     */
    private Date startTime;
    /**
     * 结束时间
     */
    private Date endTime;
    /**
     * 地址
     */
    private String taskAddress;
    /**
     * 订单状态
     */
    private Integer orderStatus;
    /**
     * 图片地址
     */
    private String imageUrl;
    /**
     * 纬度
     */
    private BigDecimal lat;
    /**
     * 经度
     */
    private BigDecimal lon;
    /**
     * 下单人id
     */
    private Integer userAccountId;
    
    private Date createTime;
    
    private Date updateTime;

    public TaskOrderDO(OrderTaskVO orderTaskVO) {
        this.inspectionId = orderTaskVO.getInspectionId();
        this.taskAddress = orderTaskVO.getTaskAddress();
        this.startTime = orderTaskVO.getStartTime();
        this.endTime = orderTaskVO.getEndTime();
        this.lon = orderTaskVO.getLon();
        this.lat = orderTaskVO.getLat();
    }

    public void defaultInfo() {
        if (orderStatus == null) {
            orderStatus = 0;
        }
    }
}

