package com.mmc.csf.release.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.mmc.csf.common.util.web.HttpHelper;
import com.mmc.csf.common.util.web.HttpsRequestUtil;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.common.util.web.ResultEnum;
import com.mmc.csf.common.util.wx.WXMsgPushUtils;
import com.mmc.csf.release.constant.UserSystemConstant;
import com.mmc.csf.release.constant.WxConstant;
import com.mmc.csf.release.service.WxApiService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @Author LW
 * @date 2023/7/12 14:05
 * 概要：
 */
@Service
public class WxApiServiceImpl implements WxApiService {
    @Autowired
    private UserSystemConstant userSystemConstant;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public ResultBody msgSecCheck(String openid, String content) {
        try {
            String accessToken = this.getStableAccessToken();
            JSONObject param = new JSONObject();
            param.put("content", content);
            param.put("version", 2);
            param.put("scene", 3);
            param.put("openid", openid);
            String url = "https://api.weixin.qq.com/wxa/msg_sec_check?access_token=" + accessToken;
            String res = HttpHelper.httpPost(url, param.toString());
            JSONObject result = JSONObject.parseObject(res);
            JSONObject resultData = result.getJSONObject(WxConstant.RESULT);
            if (!resultData.getString(WxConstant.LABEL).equals(WxConstant.LABEL_DATA)) {
                return ResultBody.error(ResultEnum.DYNAMIC_SENSITIVE_INFO);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultBody.success();
    }

    @Override
    public String getStableAccessToken() {
        //token有效期为7200s，需要保存起来，先从redis中获取accessToken，没有则请求获取
        String accessToken = stringRedisTemplate.opsForValue().get(WxConstant.IUAV_MINI_PROGRAM_STABLE_ACCESS_TOKEN);
        if (StringUtils.isBlank(accessToken)) {
            Map<String, String> params = new HashMap<String, String>();
            params.put("grant_type", "client_credential");
            params.put("appid", userSystemConstant.getWxAppId());
            params.put("secret", userSystemConstant.getWxAppSecret());
            String stableAccessTokenUrl = "https://api.weixin.qq.com/cgi-bin/stable_token";
            String res = null;
            try {
                res = HttpsRequestUtil.httpsRequest(stableAccessTokenUrl, "POST", null, JSONObject.toJSONString(params));
            } catch (Exception e) {
                e.printStackTrace();
            }
            JSONObject tokenResult = JSONObject.parseObject(res);
            if (res.indexOf("access_token") == -1) {
                return null;
            }
            accessToken = tokenResult.getString("access_token");
            long expiresIn = tokenResult.getLong("expires_in");
            //保存进redis
            stringRedisTemplate.opsForValue().set(WxConstant.IUAV_MINI_PROGRAM_STABLE_ACCESS_TOKEN, accessToken, expiresIn, TimeUnit.SECONDS);
            return accessToken;
        }
        return accessToken;
    }


    @Override
    public String checkSignature(Map<String, String> params) throws Exception {
        // 微信发送的请求中 会有四个参数
        // 微信加密签名，signature结合了开发者填写的 token 参数和请求中的 timestamp 参数、nonce参数。
        String signature = params.get("signature");
        // 随机字符串
        String echostr = params.get("echostr");
        // 时间戳
        String timestamp = params.get("timestamp");
        // 随机数
        String nonce = params.get("nonce");
        // 消息推送配置中的 Token(令牌)
        String token = "IUAVKBTMMC";
        // 验证
        String msgSignature = WXMsgPushUtils.getSHA1(token, timestamp, nonce);
        // 验证失败
        if (!signature.equals(msgSignature)) {
            return "false";
        }
        // 验证成功 将 echostr 原格式返回 ，即可完成验证
        return echostr;
    }
}
