package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.release.service.FlyerDummyService;
import com.mmc.csf.release.service.UavDummyService;
import com.mmc.csf.release.service.WebsiteService;
import com.mmc.csf.web.dto.WebsiteRangeDTO;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author LW
 * @date 2022/4/21 19:13
 * 概要：
 */
@Api(tags = {"全国网点-api"})
@RestController
@RequestMapping("/website/")
public class WebsiteController {

    @Autowired
    private WebsiteService websiteService;

    @Autowired
    private FlyerDummyService flyerDummyService;

    @Autowired
    private UavDummyService uavDummyService;

    @ApiOperation(value = "获取全国网点")
    @ApiResponses(value = {@ApiResponse(code = 200, message = "OK", response = WebsiteRangeDTO.class)})
    @GetMapping("getWebsiteList")
    public ResultBody getWebsiteList(@RequestParam Integer pageNo, @RequestParam Integer pageSize, @RequestParam Double lon, @RequestParam Double lat) {
        return ResultBody.success(websiteService.getWebsiteList(pageNo, pageSize, lon, lat));
    }

    @ApiOperation(value = "全国飞手-海点数据-fake")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/flyer/bitmap")
    public ResultBody listFlyerDummyData(@RequestParam Integer pageNo, @RequestParam Integer pageSize, @RequestParam Double lon, @RequestParam Double lat) {
        return ResultBody.success(flyerDummyService.listDummyFlyer(pageNo, pageSize, lon, lat));
    }

    @ApiOperation(value = "全国无人机-海点数据-fake")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/uav/bitmap")
    public ResultBody listUavDummys(@RequestParam Integer pageNo, @RequestParam Integer pageSize, @RequestParam Double lon, @RequestParam Double lat) {
        return ResultBody.success(uavDummyService.listDummyUav(pageNo, pageSize, lon, lat));
    }

    @ApiOperation(value = "全国维修-海点数据")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/maintain/bitmap")
    public ResultBody listMaintainData(@RequestParam Integer pageNo, @RequestParam Integer pageSize, @RequestParam Double lon, @RequestParam Double lat) {
        return ResultBody.success(websiteService.listMaintainData(pageNo, pageSize, lon, lat));
    }
}
