package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.release.dao.WebsiteDao;
import com.mmc.csf.release.entity.store.MaintainDO;
import com.mmc.csf.release.entity.store.WebsiteInfoDO;
import com.mmc.csf.release.service.WebsiteService;
import com.mmc.csf.web.dto.MaintainDTO;
import com.mmc.csf.web.dto.WebsiteRangeDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author LW
 *
 * @date 2022/4/21 19:19 概要：
 */
@Service
public class WebsiteServiceImpl implements WebsiteService {
  @Autowired private WebsiteDao websiteDao;

  @Override
  public PageResult listMaintainData(Integer pageNo, Integer pageSize, Double lon, Double lat) {
    int count = websiteDao.countMaintain();
    if (count == 0) {
      return PageResult.buildPage(pageNo, pageSize, count);
    }
    List<MaintainDTO> list =
        websiteDao.listMaintain(lon, lat, (pageNo - 1) * pageSize, pageSize).stream()
            .map(MaintainDO::buildMaintainDTO)
            .collect(Collectors.toList());
    return PageResult.buildPage(pageNo, pageSize, count, list);
  }

  @Override
  public PageResult getWebsiteList(Integer pageNo, Integer pageSize, Double lon, Double lat) {
    int count = websiteDao.countWebsiteList();
    if (count == 0) {
      return PageResult.buildPage(pageNo, pageSize, count);
    }
    List<WebsiteRangeDTO> list =
        websiteDao.getWebsiteList(lon, lat, (pageNo - 1) * pageSize, pageSize).stream()
            .map(WebsiteInfoDO::buildWebsiteRangeDTO)
            .collect(Collectors.toList());
    return PageResult.buildPage(pageNo, pageSize, count, list);
  }
}
