package com.mmc.csf.release.service;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.qo.ServiceOrderQO;
import com.mmc.csf.release.auth.dto.LoginSuccessDTO;
import com.mmc.csf.release.entity.requirements.OrderAmountDetailDO;

import java.util.List;

/**
 * @Author small
 * @Date 2023/8/29 10:19
 * @Version 1.0
 */
public interface BackRequirementsService {
    PageResult serviceOrderFormList(ServiceOrderQO param, LoginSuccessDTO userLoginInfoFromRedis);

    ResultBody serviceOrderFormDetails(Integer requirementsInfoId, LoginSuccessDTO userLoginInfoFromRedis);

    /**
     * 根据订单id获取到这个订单的金额具体明细
     * @param requirementsInfoId 订单id
     * @return {@link ResultBody}
     */
    ResultBody getOrderAmountDetails(Integer requirementsInfoId);

    /**
     * 先删除之前的默认数据 再新增
     * @param list
     * @return {@link ResultBody}
     */
    ResultBody updateOrderAmountDetails(List<OrderAmountDetailDO> list);


    /**
     * 批量添加
     * @param list 列表
     * @return {@link ResultBody}
     */
    ResultBody insertOrderAmountDetails(List<OrderAmountDetailDO> list);
}
