package com.mmc.csf.release.entity.requirements;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 
 * @TableName order_amount_detail
 */
@Data
public class OrderAmountDetailDO implements Serializable {
    /**
     * 
     */
    private Integer id;


    /**
     * 订单id
     */
    @ApiModelProperty(value = "订单id",required = true)
    @NotNull(message = "订单id不能为空")
    private Integer requirementsInfoId;

    /**
     * 每天的工资
     */
    @ApiModelProperty(value = "每天的工资")
    private BigDecimal dailyWage;

    /**
     * 节日补贴
     */
    @ApiModelProperty(value = "节日补贴")
    private BigDecimal subsidyFestival;

    /**
     * 租房补贴
     */
    @ApiModelProperty(value = "租房补贴")
    private BigDecimal rentalSubsidy;

    /**
     * 交通补贴
     */
    @ApiModelProperty(value = "交通补贴")
    private BigDecimal trafficSubsidy;

    /**
     * 高温补贴
     */
    @ApiModelProperty(value = "高温补贴")
    private BigDecimal highTemperatureSubsidy;

    /**
     * 结算比例
     */
    @ApiModelProperty(value = "结算比例")
    private BigDecimal settleAccountsProportion;

    /**
     * 实际工资 上边加一起乘以结算比例
     */
    @ApiModelProperty(value = "实际工资")
    private BigDecimal realWages;

    /**
     * 工作的时间
     */
    @ApiModelProperty(value = "工作时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date workDate;

    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 
     */
    public Integer getRequirementsInfoId() {
        return requirementsInfoId;
    }

    /**
     * 
     */
    public void setRequirementsInfoId(Integer requirementsInfoId) {
        this.requirementsInfoId = requirementsInfoId;
    }

    /**
     * 每天的工资
     */
    public BigDecimal getDailyWage() {
        return dailyWage;
    }

    /**
     * 每天的工资
     */
    public void setDailyWage(BigDecimal dailyWage) {
        this.dailyWage = dailyWage;
    }

    /**
     * 节日补贴
     */
    public BigDecimal getSubsidyFestival() {
        return subsidyFestival;
    }

    /**
     * 节日补贴
     */
    public void setSubsidyFestival(BigDecimal subsidyFestival) {
        this.subsidyFestival = subsidyFestival;
    }

    /**
     * 租房补贴
     */
    public BigDecimal getRentalSubsidy() {
        return rentalSubsidy;
    }

    /**
     * 租房补贴
     */
    public void setRentalSubsidy(BigDecimal rentalSubsidy) {
        this.rentalSubsidy = rentalSubsidy;
    }

    /**
     * 交通补贴
     */
    public BigDecimal getTrafficSubsidy() {
        return trafficSubsidy;
    }

    /**
     * 交通补贴
     */
    public void setTrafficSubsidy(BigDecimal trafficSubsidy) {
        this.trafficSubsidy = trafficSubsidy;
    }

    /**
     * 高温补贴
     */
    public BigDecimal getHighTemperatureSubsidy() {
        return highTemperatureSubsidy;
    }

    /**
     * 高温补贴
     */
    public void setHighTemperatureSubsidy(BigDecimal highTemperatureSubsidy) {
        this.highTemperatureSubsidy = highTemperatureSubsidy;
    }

    /**
     * 结算比例
     */
    public BigDecimal getSettleAccountsProportion() {
        return settleAccountsProportion;
    }

    /**
     * 结算比例
     */
    public void setSettleAccountsProportion(BigDecimal settleAccountsProportion) {
        this.settleAccountsProportion = settleAccountsProportion;
    }

    /**
     * 实际工资 上边加一起乘以结算比例
     */
    public BigDecimal getRealWages() {
        return realWages;
    }

    /**
     * 实际工资 上边加一起乘以结算比例
     */
    public void setRealWages(BigDecimal realWages) {
        this.realWages = realWages;
    }

    /**
     * 工作的时间
     */
    public Date getWorkDate() {
        return workDate;
    }

    /**
     * 工作的时间
     */
    public void setWorkDate(Date workDate) {
        this.workDate = workDate;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        OrderAmountDetailDO other = (OrderAmountDetailDO) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getRequirementsInfoId() == null ? other.getRequirementsInfoId() == null : this.getRequirementsInfoId().equals(other.getRequirementsInfoId()))
            && (this.getDailyWage() == null ? other.getDailyWage() == null : this.getDailyWage().equals(other.getDailyWage()))
            && (this.getSubsidyFestival() == null ? other.getSubsidyFestival() == null : this.getSubsidyFestival().equals(other.getSubsidyFestival()))
            && (this.getRentalSubsidy() == null ? other.getRentalSubsidy() == null : this.getRentalSubsidy().equals(other.getRentalSubsidy()))
            && (this.getTrafficSubsidy() == null ? other.getTrafficSubsidy() == null : this.getTrafficSubsidy().equals(other.getTrafficSubsidy()))
            && (this.getHighTemperatureSubsidy() == null ? other.getHighTemperatureSubsidy() == null : this.getHighTemperatureSubsidy().equals(other.getHighTemperatureSubsidy()))
            && (this.getSettleAccountsProportion() == null ? other.getSettleAccountsProportion() == null : this.getSettleAccountsProportion().equals(other.getSettleAccountsProportion()))
            && (this.getRealWages() == null ? other.getRealWages() == null : this.getRealWages().equals(other.getRealWages()))
            && (this.getWorkDate() == null ? other.getWorkDate() == null : this.getWorkDate().equals(other.getWorkDate()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getRequirementsInfoId() == null) ? 0 : getRequirementsInfoId().hashCode());
        result = prime * result + ((getDailyWage() == null) ? 0 : getDailyWage().hashCode());
        result = prime * result + ((getSubsidyFestival() == null) ? 0 : getSubsidyFestival().hashCode());
        result = prime * result + ((getRentalSubsidy() == null) ? 0 : getRentalSubsidy().hashCode());
        result = prime * result + ((getTrafficSubsidy() == null) ? 0 : getTrafficSubsidy().hashCode());
        result = prime * result + ((getHighTemperatureSubsidy() == null) ? 0 : getHighTemperatureSubsidy().hashCode());
        result = prime * result + ((getSettleAccountsProportion() == null) ? 0 : getSettleAccountsProportion().hashCode());
        result = prime * result + ((getRealWages() == null) ? 0 : getRealWages().hashCode());
        result = prime * result + ((getWorkDate() == null) ? 0 : getWorkDate().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", requirementsInfoId=").append(requirementsInfoId);
        sb.append(", dailyWage=").append(dailyWage);
        sb.append(", subsidyFestival=").append(subsidyFestival);
        sb.append(", rentalSubsidy=").append(rentalSubsidy);
        sb.append(", trafficSubsidy=").append(trafficSubsidy);
        sb.append(", highTemperatureSubsidy=").append(highTemperatureSubsidy);
        sb.append(", settleAccountsProportion=").append(settleAccountsProportion);
        sb.append(", realWages=").append(realWages);
        sb.append(", workDate=").append(workDate);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}