package com.mmc.csf.release.dao;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;

import com.mmc.csf.release.entity.curriculum.CurriculumInfoDO;
import com.mmc.csf.release.entity.curriculum.FlightSkillsDO;
import com.mmc.csf.release.entity.curriculum.PilotRegistrationDO;
import com.mmc.csf.release.flyer.qo.CurriculumQo;
import com.mmc.csf.release.flyer.vo.DronePilotLicenseVO;

/**
 * @Author LW
 * @date 2023/5/15 11:34
 * 概要：
 */
@Mapper
public interface FlyerTrainingDao {

    /**
     * 插入飞手报名登记信息
     *
     * @param pilotRegistrationDO 飞行员信息登记
     */
    void insertPilotRegistrationInfo(PilotRegistrationDO pilotRegistrationDO);

    List<DronePilotLicenseVO> selectAllLicenses();

    /**
     * 课程技能列表
     *
     * @return {@link List}<{@link FlightSkillsDO}>
     */
    List<FlightSkillsDO> listIndustryFlightSkills();

    int countCurriculumInfoList(CurriculumQo curriculumQo);

    /**
     * 课程信息列表页面
     *
     * @param curriculumQo 课程问:
     * @return {@link List}<{@link CurriculumInfoDO}>
     */
    List<CurriculumInfoDO> listPageCurriculumInfo(CurriculumQo curriculumQo);

    /**
     * 查询考证视频
     *
     * @return {@link List}<{@link CurriculumInfoDO}>
     */
    List<CurriculumInfoDO> selectLicensesCurriculum();

    /**
     * 查询技能课程
     *
     * @param type 类型
     * @return {@link List}<{@link CurriculumInfoDO}>
     */
    List<CurriculumInfoDO> selectSkillCurriculum(Integer type);

    CurriculumInfoDO curriculumDetails(Integer id);

    /**
     * 添加课程信息
     *
     * @param currInfoDO
     */
    Integer addCurriculum(CurriculumInfoDO currInfoDO);

    /**
     * 修改课程信息
     *
     * @param currInfoDO
     */
    Integer updateCurriculum(CurriculumInfoDO currInfoDO);

    /**
     * 删除课程
     *
     * @param id
     */
    Integer removeCurriculum(Integer id);

    /**
     * 课程技能列表
     *
     * @return
     */
    List<FlightSkillsDO> treeCurriculumSkill();

    int countCurriculumInfo(Integer categoriesId);

    Integer getCurriculumCount();
}
