package com.mmc.csf.release.flyer.vo;

import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author LW
 * @date 2023/5/17 14:28
 * 概要:课程信息
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CurriculumInfoVO implements Serializable {
    private static final long serialVersionUID = -7343885960160805850L;
    @ApiModelProperty(value = "课程id")
    @NotNull(message = "课程id不能为空" ,groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "价格")
    private BigDecimal price;

    @ApiModelProperty(value = "供应商名称")
    private String supplierName;

    @ApiModelProperty(value = "课程名称，长度30")
    @Length(max = 30)
    private String curriculumName;

    @ApiModelProperty(value = "课程是否免费 0：免费 1：付费")
    private Integer free;

    @ApiModelProperty(value = "课程类型，二级id")
    @NotNull(message = "课程类型id不能为空" ,groups = {Insert.class})
    private Integer categoriesId;

    @ApiModelProperty(value = "目录名称", example = "技能")
    private String directoryName;

    @ApiModelProperty(value = "课程类型名称", example = "通用巡检")
    private String categoriesName;

    @ApiModelProperty(value = "课程技能类型，二级id")
    private Integer flightSkills;

    @ApiModelProperty(value = "课程介绍（简介）, 长度255")
    @Length(max = 255)
    private String curriculumDesc;

    @ApiModelProperty(value = "课程封面")
    private String surfaceUrl;

    @ApiModelProperty(value = "课程视频")
    private String videoUrl;

    @ApiModelProperty(value = "课程详情")
    private String detailContent;
}
