package com.mmc.csf.infomation.vo;


import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Freeze;
import com.mmc.csf.release.model.group.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class TenderApplyQO implements Serializable {
    private static final long serialVersionUID = -5519324350926972959L;
    @ApiModelProperty(value = "招标id")
    private Integer tenderNewsId;
    @ApiModelProperty(value = "招标详情id")
    private Integer tenderInfoId;
    @ApiModelProperty(value = "用户名",example = "用户名")
    private String userName;
    @ApiModelProperty(value = "页码")
    @NotNull(message = "页码不能为空", groups = { Page.class})
    @Min(value = 1, groups = Page.class,message = "pageNo不能少于1")
    private Integer pageNo;
    @ApiModelProperty(value = "每页显示数")
    @NotNull(message = "每页显示数不能为空", groups = { Page.class})
    @Min(value = 1, groups = Page.class,message = "pageSize不能少于1")
    private Integer pageSize;
}
