package com.mmc.csf.infomation.vo;

import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/9/8 15:23
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class LiabilityProblemVO {

    @ApiModelProperty(value = "id")
    @NotNull(message = "修改id不能为空", groups = {Update.class})
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "责任问题 1:双方无责 2:发布者责任 3：飞手责任 ",example = "1")
    @NotNull(message = "责任类型不能为空")
    private Integer  duty;


    @ApiModelProperty(value = "客服判定内容",example = "双方无责")
    private String decisionContent;

    @ApiModelProperty(value = "用户id",hidden = true)
    private Integer userAccountId;



}
