package com.mmc.csf.infomation.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/29 13:45
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PlatformOrderEarningsDTO {

    @ApiModelProperty(value = "普通置顶或者加急的金额", example = "300")
    private BigDecimal orderLevelAmount;

    @ApiModelProperty(value = "订单级别 REGULAR_ORDER,RUSH_ORDER,TOP_ORDER", example = "TOP_ORDER")
    private String orderLevel;


    @ApiModelProperty(value = "订单佣金收益", example = "100")
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "违约金收益", example = "10")
    private BigDecimal liquidatedDamages;

    @ApiModelProperty(value = "需求id")
    private Integer requirementsInfoId;

    @ApiModelProperty(value = "创建时间")
    private String createTime;

    @ApiModelProperty(value = "修改时间")
    private String updateTime;
    

}
