package com.mmc.csf.release.entity.forum;

import com.mmc.csf.release.entity.gambit.ForumGambitDO;
import com.mmc.csf.user.vo.UserAccountVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author small
 * @Date 2023/9/16 9:57
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ForumDynamicUserDO implements Serializable {
    private static final long serialVersionUID = 570379773690905364L;


    private Integer id;

    /**
     * 版本字段
     */
    private Integer version;
    /**
     * 发布用户ID
     */
    private Integer userAccountId;
    /**
     * 动态描述
     */
    private String description;
    /**
     * 发布动态具体位置
     */
    private String location;
    /**
     * 发布动态纬度
     */
    private BigDecimal lat;
    /**
     * 发布动态经度
     */
    private BigDecimal lon;
    /**
     * 点赞数
     */
    private Integer likesCount;
    /**
     * 评论数
     */
    private Integer commentsCount;
    /**
     * 记录父节点id
     */
    private String rootPath;

    private Integer checkStatus;

    private List<ForumResourceDO> forumResourceDOList;

    private List<ForumGambitDO> forumGambitDOList;


    private UserAccountVO userAccountVO;







}
