package com.mmc.csf.release.forum.vo;

import com.mmc.csf.release.gambit.dto.ForumGambitDTO;
import com.mmc.csf.release.gambit.vo.ForumGambitVO;
import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author LW
 *
 * @date 2023/5/15 10:29 概要：动态信息参数
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class DynamicVO implements Serializable {

  @ApiModelProperty(value = "话题名称",example = "#深圳暴雨,#深圳大雨")
  private List<String> gambitName;

  @ApiModelProperty(value = "话题图标",example = "小程序给默认值")
  @NotBlank(message = "话题图标不能为空",groups = {Create.class, Update.class})
  private String gambitIcon;

  @ApiModelProperty(value = "话题封面",example = "小程序给默认封面")
  @NotBlank(message = "话题封面不能为空",groups = {Create.class,Update.class})
  private String gambitCover;


  @ApiModelProperty(value = "发布动态用户信息")
  private UserBaseInfoVO userBaseInfo;

  @ApiModelProperty(value = "用户id")
  private Integer userAccountId;

  @ApiModelProperty(value = "动态id")
  private Integer id;

  @ApiModelProperty(value = "动态描述")
  private String description;

  @ApiModelProperty(value = "位置信息")
  private String location;

  @ApiModelProperty(value = "纬度")
  private BigDecimal lat;

  @ApiModelProperty(value = "经度")
  private BigDecimal lon;

  @ApiModelProperty(value = "媒体资源")
  private List<MediaVO> mediaVO;

  @ApiModelProperty(value = "点赞数")
  private Integer likesCount;

  @ApiModelProperty(value = "评论数")
  private Integer commentCount;

  @ApiModelProperty(value = "是否点赞")
  private Boolean likes;

  @ApiModelProperty(value = "动态发布时间")
  private Date dynamicPublishTime;

  @ApiModelProperty(value = "评论信息")
  private List<DynamicVO> commentAndReplyVO;

  @ApiModelProperty("评论")
  private ForumReviewVO forumReviewVO;

  @ApiModelProperty(value = "话题列表")
  private List<ForumGambitDTO> forumGambitDTOList;


  @ApiModelProperty(value = "转发数")
  private Integer transpond;

  @ApiModelProperty(value = "关注状态")
  private Boolean status;


}
