package com.mmc.csf.release.forum.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author LW
 *
 * @date 2023/5/15 10:29 概要：评论信息参数
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CommentVO implements Serializable {


  @ApiModelProperty(value = "动态id",example = "1")
  private Integer dynamicId;

  @ApiModelProperty(value = "评论内容",example = "你好")
  private String content;

  @ApiModelProperty(value = "评论id(注意:单纯评论就为0 ,有回复就评论id) ",example = "0")
  private Integer reviewId;

  @ApiModelProperty(value = "用户id",hidden = true)
  private Integer userAccountId;

  @ApiModelProperty(value = "pid(注意:单纯评论就为0,有回复就上级id)",example = "0")
  private Integer pid;







}
