package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.release.dao.WebsiteDao;
import com.mmc.csf.release.service.FlyerDummyService;
import com.mmc.csf.web.dto.DummyFlyerDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * Author: geDuo
 * Date: 2022/5/24 15:21
 */
@Service
public class FlyerDummyServiceImpl implements FlyerDummyService {

    @Autowired
    private WebsiteDao websiteDao;

    @Override
    public PageResult listDummyFlyer(Integer pageNo, Integer pageSize, Double lon, Double lat) {
        int count = websiteDao.countDummyFlyer();
        if (count == 0) {
            return PageResult.buildPage(pageNo, pageSize, count);
        }
        List<DummyFlyerDTO> list = websiteDao.listDummyFlyer(lon, lat, (pageNo - 1) * pageSize, pageSize).stream().map(d -> d.buildDummyFlyerDTO()).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, pageSize, count, list);
    }
}
