package com.mmc.csf.release.service;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.IndustryCaseVO;
import com.mmc.csf.release.auth.dto.LoginSuccessDTO;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/19 13:40
 */
public interface IndustryCaseService {
    /**
     * 案例列表
     * @param industryCaseQO
     * @param request
     * @return
     */
    ResultBody listCasePage(IndustryCaseQO industryCaseQO, HttpServletRequest request);

    /**
     * 案例详情
     * @param id
     * @return
     */
    ResultBody details(Integer id);

    /**
     * 添加业务案例
     * @param industryCaseVO
     * @param userLoginInfo
     * @return
     */
    ResultBody addCase(IndustryCaseVO industryCaseVO, LoginSuccessDTO userLoginInfo);

    /**
     * 修改业务案例
     * @param industryCaseVO
     * @param userLoginInfo
     * @return
     */
    ResultBody updateCase(IndustryCaseVO industryCaseVO, LoginSuccessDTO userLoginInfo);

    /**
     * 删除业务案例
     * @param id
     * @return
     */
    ResultBody deleteDetails(Integer id);
}
