package com.mmc.csf.release.feign;


import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.PilotCertificationInteriorDTO;
import com.mmc.csf.infomation.dto.TeamMessageDO;
import com.mmc.csf.infomation.dto.UserAccountSimpleDTO;
import com.mmc.csf.infomation.dto.UserBaseInfoDTO;
import com.mmc.csf.release.auth.qo.BUserAccountQO;
import com.mmc.csf.release.auth.qo.UserAccountQO;
import com.mmc.csf.release.feign.hystrix.UserAppApiHystrix;
import com.mmc.csf.release.flyer.vo.CurriculumOrderLogVO;
import com.mmc.csf.user.vo.ChangeUserPointVO;
import com.mmc.csf.user.vo.WxMsgVO;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 17:06
 */
//@FeignClient(name = "cms-svc", fallback = UserAppApiHystrix.class)
@FeignClient(url = "${iuav.userapp.url}", name = "cms-svc", fallback = UserAppApiHystrix.class)
public interface UserAppApi {
    /**
     * 根据用户id获取基本信息
     *
     * @param userAccountId
     * @return
     */
    @RequestMapping(value = "/userapp/user-account/feignGetUserSimpleInfo", method = RequestMethod.GET)
    public UserAccountSimpleDTO feignGetUserSimpleInfo(@RequestParam Integer userAccountId, @RequestHeader("token") String token);

    /**
     * 根据地区信息查询用户id
     *
     * @param provinceCode
     * @param cityCode
     * @param districtCode
     * @return
     */
    @GetMapping("/userapp/user-account/feignListUserAccountIds")
    List<Integer> feignListUserAccountIds(@RequestParam Integer provinceCode, @RequestParam(required = false) Integer cityCode,
                                          @RequestParam(required = false) Integer districtCode, @RequestHeader(value = "token", required = false) String token);


    /**
     * 获取后台用户集合列表页面
     *
     * @param bUserAccountQO 问:b用户帐户
     * @return {@link List}<{@link UserAccountSimpleDTO}>
     */
    @PostMapping("/userapp/back-user/feignListBAccountPage")
    List<UserAccountSimpleDTO> feignListBAccountPage(@ApiParam(value = "账号查询QO", required = true) @RequestBody BUserAccountQO bUserAccountQO, @RequestHeader("token") String token);

    /**
     * 获取小程序用户集合列表页面
     *
     * @param userAccountQO
     * @param token
     * @return
     */
    @PostMapping("/userapp/user-account/feignListAppUserAccount")
    List<UserAccountSimpleDTO> feignListAppUserAccount(@ApiParam(value = "账号查询QO", required = true) @RequestBody UserAccountQO userAccountQO, @RequestHeader("token") String token);

    @PostMapping("/userapp/user-account/feignListAppUserAccount1")
    List<UserAccountSimpleDTO> feignListAppUserAccount1(@ApiParam(value = "账号查询QO", required = true) @RequestBody UserAccountQO userAccountQO);


    /**
     * 根据用户id获取基本信息
     *
     * @param userAccountId
     * @return
     */
    @GetMapping(value = "/userapp/pilot/interiorDetailPilot")
    public PilotCertificationInteriorDTO feignInteriorDetailPilot(@RequestParam(required = true) Integer userAccountId);

    @PostMapping("/userapp/userPoint/change")
    public ResultBody changeUserPoint(@RequestBody ChangeUserPointVO changePoint, @RequestHeader("token") String token);

    @GetMapping("/userapp/pilot/selectPilotIdList")
    List<Integer> feignGetPilotIdList(@RequestHeader("token") String token);

    @GetMapping("/userapp/user-account/feignGetUserBaseInfo")
    UserBaseInfoDTO feignGetUserBaseInfo(@RequestParam Integer userAccountId);

    @GetMapping("/userapp/userPoint/feignChangeUserPoints")
    ResultBody feignChangeUserPoints(@RequestHeader("token") String token,@RequestHeader HttpServletRequest request, @RequestParam("id") int changePoint,@RequestParam("reason") String reason);

    @PostMapping("/userapp/pay/feignCurriculumOrderLog")
    ResultBody feignCurriculumOrderLog(@RequestHeader("token") String token,@RequestHeader HttpServletRequest request,@RequestBody CurriculumOrderLogVO curriculumOrderLogVO);

    @PostMapping("/userapp/wx/send")
    ResultBody feignSendWxMsg(@RequestHeader("token") String token,@RequestBody WxMsgVO ws);

    @GetMapping("/userapp/pilot/selectPilotTeamManagerId")
    Integer selectPilotTeamManagerId(@RequestHeader("token") String token,@RequestParam Integer pilotUserId);

    @GetMapping("/userapp/pilot/getPilotApplyPhone")
    String getPilotApplyPhone(@RequestHeader("token") String token,@RequestParam Integer userAccountId);

    @GetMapping("/userapp/userPoint/changeUserPoints")
    ResultBody changeUserPoints(@RequestHeader("token") String token,@RequestHeader HttpServletRequest request, @RequestParam("id") Integer id);
}
