package com.mmc.csf.release.entity.requirements;

import com.alibaba.fastjson.annotation.JSONField;
import com.mmc.csf.config.IsNullConvertZero;
import com.mmc.csf.infomation.dto.PilotCertificationInteriorDTO;
import com.mmc.csf.release.entity.information.PersonSendOrderDO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/18 17:23
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RequirementsServiceDO implements Serializable {
    private static final long serialVersionUID = -1811974173256250060L;

    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "服务需求id")
    private Integer requirementsInfoId;
    @ApiModelProperty(value = "字典id暂时无用")
    private Integer serviceDictionaryId;

    @ApiModelProperty(value = "抢单飞手id")
    private Integer pilotCertificationId;
    @ApiModelProperty(value = "抢单飞手用户id")
    private Integer pilotCertificationUserId;

    @ApiModelProperty(value = "抢单飞手团队id")
    private Integer teamId;
    @ApiModelProperty(value = "抢单飞手团队用户id")
    private Integer teamUserId;

    @ApiModelProperty(value = "云享金", example = "10")
    @IsNullConvertZero
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "佣金", example = "10")
    @IsNullConvertZero
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "微信金额", example = "10")
    @IsNullConvertZero
    private BigDecimal weChat;

    @ApiModelProperty(value = "微信支付订单编号", example = "R202308191657303116170")
    private String wechatPayOrderNumber;

    @ApiModelProperty(value = "抢单支付的总金额", example = "抢单支付的总金额")
    @IsNullConvertZero
    private BigDecimal preemptTotalAmount;
    @ApiModelProperty(value = "任务流程id", example = "任务流程id")
    private Integer serviceFlowId;

    @ApiModelProperty(value = "发布者用户id")
    private Integer userAccountId;
    @ApiModelProperty(value = "订单编号")
    private String publisherNumber;
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @ApiModelProperty(value = "任务佣金")
    @IsNullConvertZero
    private BigDecimal percentagePenaltyOfOrder;
    @ApiModelProperty(value = "发布者订单的任务佣金")
    @IsNullConvertZero
    private BigDecimal orderAmount;
    @ApiModelProperty(value = "抢单者openid")
    private String openid;
    @ApiModelProperty(value = "手机号", hidden = true)
    private String phoneNum;

    @ApiModelProperty(value = "平台总收益")
    @IsNullConvertZero
    private BigDecimal orderEarnings;


    public RequirementsServiceDO(PilotCertificationInteriorDTO pilot, ServiceRequirementsDO requirementsInfoDO) {
        this.pilotCertificationId = pilot.getId();
        this.pilotCertificationUserId = pilot.getUserAccountId();
        this.requirementsInfoId = requirementsInfoDO.getId();
    }

    /**
     * 派单信息同步
     */
    public RequirementsServiceDO(PersonSendOrderDO personSendOrderDO){
        this.requirementsInfoId = personSendOrderDO.getRequirementsInfoId();
        this.pilotCertificationId = personSendOrderDO.getPilotCertificationId();
        this.pilotCertificationUserId = personSendOrderDO.getPilotCertificationUserId();
        this.teamUserId = personSendOrderDO.getTeamUserId();
        this.teamId = personSendOrderDO.getTeamId();
        this.serviceFlowId = 2;
    }
}
