package com.mmc.csf.infomation.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @Author small
 * @Date 2023/8/26 13:54
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class UpdateAmountGetNumberVO {
    @ApiModelProperty(value = "修改订单金额", example = "100.00", required = true)
    //@NotNull(message = "订单金额", groups = {Insert.class})
    //@DecimalMin(value = "100.00", message = "amount格式不正确")
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "云享金", example = "10", hidden = true)
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "佣金", example = "10", hidden = true)
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "微信金额", example = "10", hidden = true)
    private BigDecimal weChatPay;

    @ApiModelProperty(value = "用户id", example = "10", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "支付方式，云享金：1，佣金：2，微信支付：3", example = "1,2,3", required = true)
    private String paymentType;

    @ApiModelProperty(value = "抢单时需要知道抢单的那个订单", example = "1", required = true)
    private Integer requirementsInfoId;
}
