package com.mmc.csf.infomation.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/23 14:25
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class BannerInfoDTO implements Serializable {
    private static final long serialVersionUID = -7448333029172826676L;
    @ApiModelProperty(value = "banner的id")
    private Integer id;
    @ApiModelProperty(value = "模块id")
    private Integer moduleId;
    @ApiModelProperty(value = "banner名称")
    private String bannerName;
    @ApiModelProperty(value = "banner图片url")
    private String bannerImg;
    @ApiModelProperty(value = "banner海报url")
    private String bannerPoster;
    @ApiModelProperty(value = "banner类型")
    private Integer bannerType;
    @ApiModelProperty(value = "商品id")
    private Integer goodsId;
    @ApiModelProperty(value = "点击后的页面地址")
    private String bannerUrl;
    @ApiModelProperty(value = "描述信息")
    private String detailInfo;
    @ApiModelProperty(value = "顺序")
    private Integer sort;
    @ApiModelProperty(value = "富文本内容")
    private String textContent;
    @ApiModelProperty(value = "有效开始时间")
    private Date startTime;
    @ApiModelProperty(value = "有效结束时间")
    private Date endTime;
    @ApiModelProperty(value = "是否上架")
    private Integer using;
    @ApiModelProperty(value = "是否删除")
    private Integer deleted;
    @ApiModelProperty(value = "生成时间")
    private Date createTime;
}
