package com.mmc.csf.release.entity.requirements;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.mmc.csf.config.IsNullConvertZero;
import com.mmc.csf.infomation.vo.OrderLevelEnum;
import com.mmc.csf.infomation.vo.ServiceRequirementsVO;
import com.mmc.csf.release.model.group.Insert;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/17 10:54
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ServiceRequirementsDO {
    private static final long serialVersionUID = -447951390213113317L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "id")
    @NotBlank(message = "服务类型id不能为空", groups = {Insert.class, Update.class})
    private Integer serviceId;

    @ApiModelProperty(value = "飞行日期——任务开始时间", example = "2023-07-25", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskStartTime;

    @ApiModelProperty(value = "飞行日期——任务结束时间", example = "2023-07-26", required = true)
    @NotNull(message = "任务开始时间不能为空", groups = {Insert.class, Update.class})
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskEndTime;

    @ApiModelProperty(value = "飞行位置——任务地址", example = "广东省深圳市", required = true)
    @NotBlank(message = "任务地址不能为空", groups = {Insert.class, Update.class})
    private String taskAddress;


    @ApiModelProperty(value = "飞行位置——任务经度", example = "23.344324", required = true)
    @NotNull(message = "任务经度不能为空", groups = {Insert.class, Update.class})
    private Double longitude;

    @ApiModelProperty(value = "飞行位置——任务纬度", example = "44.344324", required = true)
    @NotNull(message = "任务纬度不能为空", groups = {Insert.class, Update.class})
    private Double latitude;


    @ApiModelProperty(value = "需求描述", example = "描述一下", required = true)
    @NotNull(message = "需求描述不能为空", groups = {Insert.class})
    @Length(max = 300, message = "字符过长")
    private String requireDescription;

    @ApiModelProperty(value = "订单金额", example = "订单金额", required = true)
    @NotNull(message = "订单金额", groups = {Insert.class})
    @IsNullConvertZero
    private BigDecimal orderAmount;

    @ApiModelProperty(value = "飞手保险", example = "飞手保险", required = true)
    @NotNull(message = "飞手保险", groups = {Insert.class})
    private String insurance;

    @ApiModelProperty(value = "订单级别", example = "订单级别", required = true)
    @NotNull(message = "订单级别", groups = {Insert.class})
    private OrderLevelEnum orderLevelEnum;

    @ApiModelProperty(value = "后台获取token里面的用户id", hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "发布者姓名", example = "张三")
    private String publishName;

    @ApiModelProperty(value = "发布者电话", example = "1892994543", required = true)
    @NotNull(message = "发布者电话不能为空", groups = {Insert.class})
    private String publishPhone;

    @ApiModelProperty(value = "发布者订单编号")
    private String publisherNumber;

    @ApiModelProperty(value = "0普通 100急单 300置顶")
    @IsNullConvertZero
    private BigDecimal orderLevelAmount;

    @ApiModelProperty(value = "订单级别 REGULAR_ORDER,RUSH_ORDER,TOP_ORDER")
    private String orderLevel;

    @ApiModelProperty(value = "总金额", example = "100", required = true)
    @NotNull(message = "总金额", groups = {Insert.class})
    @IsNullConvertZero
    private BigDecimal totalAmount;


    @ApiModelProperty(value = "云享金", example = "10")
    @IsNullConvertZero
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "佣金", example = "10")
    @IsNullConvertZero
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "微信金额", example = "10")
    @IsNullConvertZero
    private BigDecimal weChat;

    @ApiModelProperty(value = "微信支付订单编号", example = "R202308191657303116170")
    private String wechatPayOrderNumber;

    private Integer repertory;


    @ApiModelProperty(value = "支付方式，云享金：1，佣金：2，微信支付：3", example = "1,2,3")
    private String paymentType;
    @ApiModelProperty(value = "地区编码")
    private String adcode;
    @IsNullConvertZero
    @ApiModelProperty(value = "置顶/加急 佣金支付多少", example = "100")
    private BigDecimal levelSalaryAmount;
    @ApiModelProperty(value = "置顶/加急 微信支付多少", example = "100")
    @IsNullConvertZero
    private BigDecimal levelWeChatAmount;
    @ApiModelProperty(value = "置顶/加急 云享金支付多少", example = "100")
    @IsNullConvertZero
    private BigDecimal levelCashAmount;
    @ApiModelProperty(value = "openid")
    private String openid;

    @ApiModelProperty(value = "服务名称")
    private String serviceName;


    public ServiceRequirementsDO(ServiceRequirementsVO serviceRequirementsVO) {
        this.id = serviceRequirementsVO.getId();
        this.userAccountId = serviceRequirementsVO.getUserAccountId();
        this.publishName = serviceRequirementsVO.getPublishName();
        this.publishPhone = serviceRequirementsVO.getPublishPhone();
        this.requireDescription = serviceRequirementsVO.getRequireDescription();
        this.taskStartTime = serviceRequirementsVO.getTaskStartTime();
        this.taskEndTime = serviceRequirementsVO.getTaskEndTime();
        this.taskAddress = serviceRequirementsVO.getTaskAddress();
        this.longitude = serviceRequirementsVO.getLongitude();
        this.latitude = serviceRequirementsVO.getLatitude();
        this.orderLevelAmount = OrderLevelEnum.match(serviceRequirementsVO.getOrderLevelEnum().getKey()).getValue();
        this.orderLevel = serviceRequirementsVO.getOrderLevelEnum().getKey();
        this.totalAmount = serviceRequirementsVO.getOrderAmount().add(OrderLevelEnum.match(serviceRequirementsVO.getOrderLevelEnum().getKey()).getValue());
        this.serviceId = serviceRequirementsVO.getServiceId();
        this.orderAmount = serviceRequirementsVO.getOrderAmount();
        this.insurance = serviceRequirementsVO.getInsurance();
        this.cashAmount = serviceRequirementsVO.getCashAmount();
        this.salaryAmount = serviceRequirementsVO.getSalaryAmount();
        this.wechatPayOrderNumber = serviceRequirementsVO.getWechatPayOrderNumber();
        this.weChat = serviceRequirementsVO.getWeChat();
        this.paymentType = serviceRequirementsVO.getPaymentType();
        this.adcode = serviceRequirementsVO.getAdcode();
    }
}
