package com.mmc.csf.release.entity.gambit;

import com.mmc.csf.release.entity.forum.ForumDynamicDO;
import com.mmc.csf.release.gambit.dto.ForumGambitDTO;
import com.mmc.csf.release.gambit.vo.ForumGambitVO;
import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/9/13 16:06
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ForumGambitDO {


    private Integer id;

    @ApiModelProperty(value = "话题名称",example = "深圳暴雨")
    @NotBlank(message = "话题不能为空",groups = {Create.class, Update.class})
    private String gambitName;

    @ApiModelProperty(value = "话题图标",example = "小程序给默认值")
    @NotBlank(message = "话题图标不能为空",groups = {Create.class,Update.class})
    private String gambitIcon;

    @ApiModelProperty(value = "话题封面",example = "小程序给默认封面")
    @NotBlank(message = "话题封面不能为空",groups = {Create.class,Update.class})
    private String gambitCover;

    @ApiModelProperty(value = "话题属性",example = "话题属性 1普通 2热门 3推荐 (小程序默认普通：1)")
    @NotNull(message = "话题属性不能为空")
    private Integer gambitProperty;

    @ApiModelProperty(value = "发贴用户",example = "1",hidden = true)
    private Integer userAccountId;
    @ApiModelProperty(value = "贴子数",example = "11")
    private Integer postCount;
    @ApiModelProperty(value = "话题参与讨论数量",example = "1")
    private Integer discussionCount;

    private Integer checkStatus;



    public ForumGambitDO(ForumGambitVO forumGambitVO){
        this.gambitName= forumGambitVO.getGambitName();
        this.gambitIcon= forumGambitVO.getGambitIcon();
        this.gambitCover= forumGambitVO.getGambitCover();
        this.gambitProperty= forumGambitVO.getGambitProperty();
        this.userAccountId= forumGambitVO.getUserAccountId();
        this.id=forumGambitVO.getId();
    }

    public ForumGambitDO(ForumDynamicDO forumDynamicDO){
        this.gambitIcon=forumDynamicDO.getGambitIcon();
        this.gambitCover=forumDynamicDO.getGambitCover();
        this.userAccountId= forumDynamicDO.getUserAccountId();

    }


    public ForumGambitDTO buildForumGambitDTO(){
        return   ForumGambitDTO.builder()
                .id(this.id)
                .gambitName(this.gambitName)
                .gambitIcon(this.gambitIcon)
                .gambitCover(this.gambitCover)
                .gambitProperty(this.gambitProperty)
                .postCount(this.postCount)
                .userAccountId(this.userAccountId)
                .discussionCount(this.discussionCount)
                .build();
    }

}
