package com.mmc.csf.release.entity.forum;

import com.mmc.csf.release.forum.vo.CommentVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/9/16 17:19
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ForumFirstLevelReviewDO implements Serializable {
    private static final long serialVersionUID = 570379773690905364L;


    @ApiModelProperty(value = "动态id")
    private Integer dynamicId;

    @ApiModelProperty(value = "评论内容")
    private String content;

    @ApiModelProperty(value = "评论id,没有回复就为0 有就是评论id ")
    private Integer reviewId;

    @ApiModelProperty(value = "用户id",hidden = true)
    private Integer userAccountId;

    @ApiModelProperty(value = "pid(注意:pid为0表示评论,回复需要上级评论id)",example = "0")
    private Integer pid;

    public ForumFirstLevelReviewDO(CommentVO commentVO){
        this.dynamicId=commentVO.getDynamicId();
        this.content=commentVO.getContent();
        this.reviewId=commentVO.getReviewId();
        this.userAccountId=commentVO.getUserAccountId();
        this.pid=commentVO.getPid();
    }



}
