package com.mmc.csf.release.entity.forum;

import com.mmc.csf.release.entity.common.BaseDO;
import com.mmc.csf.release.forum.dto.DynamicInfoDTO;
import com.mmc.csf.release.forum.vo.DynamicVO;
import com.mmc.csf.release.forum.vo.ForumReviewVO;
import com.mmc.csf.release.gambit.dto.ForumGambitDTO;
import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 动态信息表(ForumDynamicDO)实体类
 *
 * @author lw
 * @since 2023-05-16 09:50:39
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class ForumDynamicDO extends BaseDO implements Serializable {
    private static final long serialVersionUID = 570379773690905364L;


    /**
     * 版本字段
     */
    private Integer version;
    /**
     * 发布用户ID
     */
    private Integer userAccountId;
    /**
     * 动态描述
     */
    private String description;
    /**
     * 发布动态具体位置
     */
    private String location;
    /**
     * 发布动态纬度
     */
    private BigDecimal lat;
    /**
     * 发布动态经度
     */
    private BigDecimal lon;
    /**
     * 点赞数
     */
    private Integer likesCount;
    /**
     * 评论数
     */
    private Integer commentsCount;
    /**
     * 记录父节点id
     */
    private String rootPath;

    private Integer checkStatus;


    @ApiModelProperty(value = "话题图标",example = "小程序给默认值")
    @NotBlank(message = "话题图标不能为空",groups = {Create.class, Update.class})
    private String gambitIcon;

    @ApiModelProperty(value = "话题封面",example = "小程序给默认封面")
    @NotBlank(message = "话题封面不能为空",groups = {Create.class,Update.class})
    private String gambitCover;

    @ApiModelProperty(value = "话题名称",example = "#深圳暴雨")
    private List<String> gambitName;

    private Integer dynamicId;

    @ApiModelProperty("评论")
    private ForumReviewVO forumReviewVO;

    @ApiModelProperty("话题列表")
    private List<ForumGambitDTO> gambitDTOList;

    @ApiModelProperty("")
    private Integer transpond;







    public ForumDynamicDO(DynamicVO dynamicVO) {
        this.gambitIcon=dynamicVO.getGambitIcon();
        this.gambitCover=dynamicVO.getGambitCover();
        this.gambitName=dynamicVO.getGambitName();
        this.description = dynamicVO.getDescription();
        this.location = dynamicVO.getLocation();
        this.lat = dynamicVO.getLat();
        this.lon = dynamicVO.getLon();
    }

    public DynamicVO buildDynamicVO() {
        return DynamicVO.builder()
                .id(this.getId())
                .userAccountId(userAccountId)
                .description(description)
                .commentCount(commentsCount)
                .likesCount(likesCount)
                .lat(lat)
                .lon(lon)
                .location(location)
                .dynamicPublishTime(this.getCreateTime())
                .gambitName(this.gambitName)
                .forumReviewVO(this.forumReviewVO)
                .forumGambitDTOList(this.gambitDTOList)
                .transpond(this.transpond)
                .build();
    }

    public DynamicInfoDTO buildDynamicInfoDTO() {
        return DynamicInfoDTO.builder()
                .id(this.getId())
                .userAccountId(userAccountId)
                .description(description)
                .dynamicPublishTime(this.getCreateTime())
                .show(this.getDeleted())
                .checkStatus(checkStatus)
                .gambitName(this.gambitName)
                .build();
    }

    public void defaultInfo() {
        this.lon = null;
        this.lat = null;
        this.location = null;
    }
}
