package com.mmc.csf.release.entity.forum;

import com.mmc.csf.user.vo.UserAccountMessageVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/9/18 15:42
 * @Version 1.0
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class ForumCountDO implements Serializable {

    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;

    @ApiModelProperty(value = "获赞数量")
    private Integer likeCount;

    @ApiModelProperty(value = "粉丝数量")
    private Integer fansCount;

    @ApiModelProperty(value = "关注数量")
    private Integer attentionCount;

    @ApiModelProperty(value = "创建时间")
    private String createTime;

    @ApiModelProperty(value = "修改时间")
    private String updateTime;

    @ApiModelProperty(value = "是否关注",example = "true表示已关注 null没有关注")
    private Boolean status;

    @ApiModelProperty(value = "实名认证的用户信息")
    private UserAccountMessageVo userAccountMessageVo;



}
