package com.mmc.csf.release.controller;

import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.dto.ServiceOrderFormDTO;
import com.mmc.csf.infomation.dto.ServiceOrderFormDetailsDTO;
import com.mmc.csf.infomation.qo.ServiceOrderQO;
import com.mmc.csf.release.model.group.Page;
import com.mmc.csf.release.service.BackRequirementsService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author small
 * @Date 2023/8/29 10:18
 * @Version 1.0
 */
@Api(tags = {"服务需求订单后台相关"})
@RestController
@RequestMapping("/backRequirements/")
public class BackRequirementsController extends BaseController {

    @Autowired
    private BackRequirementsService backRequirementsService;

    @ApiOperation(value = "后台管理——服务订单分页")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ServiceOrderFormDTO.class)})
    @PostMapping("serviceOrderFormList")
    public ResultBody<ServiceOrderFormDTO> serviceOrderFormList(HttpServletRequest request,
                                                                @Validated(value = {Page.class}) @ApiParam(value = "角色查询QO", required = true) @RequestBody ServiceOrderQO param) {
        return ResultBody.success(backRequirementsService.serviceOrderFormList(param, this.getUserLoginInfoFromRedis(request)));
    }


    @ApiOperation(value = "后台管理——服务订单详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ServiceOrderFormDTO.class)})
    @GetMapping("serviceOrderFormDetails")
    public ResultBody<ServiceOrderFormDetailsDTO> serviceOrderFormDetails(HttpServletRequest request, @ApiParam(value = "需求发布id", required = true) @RequestParam Integer requirementsInfoId) {
        return backRequirementsService.serviceOrderFormDetails(requirementsInfoId, this.getUserLoginInfoFromRedis(request));
    }


}
