package com.mmc.csf.infomation.vo;

import com.mmc.csf.config.IsNullConvertZero;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/23 9:44
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class FlyerWalletFlowVO {

    @ApiModelProperty(value = "用户ID")
    private Integer userAccountId;

    @ApiModelProperty(value = "支付方式 100（订单发布） 200(无人接单取消订单）300（有人接单取消订单）400（飞手抢单）500（客服判定飞手无责取消订单）600（飞手有责取消订单）700（正常结算）800(修改订单金额状态)900（飞手未确认修改金额状态）1000（飞手确认修改金额状态）")
    private Integer modeOfPayment;

    @ApiModelProperty(value = "云享金（需要正负）")
    @IsNullConvertZero
    private BigDecimal cashAmount;

    @ApiModelProperty(value = "佣金（需要正负）")
    @IsNullConvertZero
    private BigDecimal salaryAmount;

    @ApiModelProperty(value = "支付时间")
    private Date timeOfPayment;

    @ApiModelProperty(value = "操作者用户id")
    private Integer operateUserAccountId;

    @ApiModelProperty(value = "云享金违约金（需要正负）")
    @IsNullConvertZero
    private BigDecimal yxjCashPledge;

    @ApiModelProperty(value = "佣金违约金（需要正负）")
    @IsNullConvertZero
    private BigDecimal salaryCashPledge;

    @ApiModelProperty(value = "订单的百分比违约金(这笔钱是给发布方的)")
    @IsNullConvertZero
    private BigDecimal percentagePenaltyOfOrder;
}
