package com.mmc.csf.release.service.impl;

import com.mmc.csf.common.util.page.PageResult;
import com.mmc.csf.common.util.web.ResultBody;
import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.infomation.vo.IndustryNewsVO;
import com.mmc.csf.release.constant.TokenConstant;
import com.mmc.csf.release.dao.IndustryNewsDao;
import com.mmc.csf.release.entity.IndustryNewsDO;
import com.mmc.csf.release.feign.UserAppApi;
import com.mmc.csf.release.service.IndustryNewsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/5/19 13:41
 */
@Service
public class IndustryNewsServiceImpl implements IndustryNewsService {
    @Autowired
    private IndustryNewsDao industryNewsDao;

    @Autowired
    private UserAppApi userAppApi;

    @Override
    public ResultBody listNewsPage(IndustryCaseQO industryCaseQO, HttpServletRequest request) {
        //查询对应地区的用户
        //查询对应地区的用户， 默认查广东
        industryCaseQO.setProvinceCode(industryCaseQO.getProvinceCode() == null  ? 440000 : industryCaseQO.getProvinceCode());
        List<Integer> userIds = userAppApi.feignListUserAccountIds(industryCaseQO.getProvinceCode(), industryCaseQO.getCityCode(), industryCaseQO.getDistrictCode(), request.getHeader(TokenConstant.TOKEN));
        industryCaseQO.setUserIds(userIds);
        int count = industryNewsDao.countListNewsPage(industryCaseQO);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(industryCaseQO.getPageNo(), industryCaseQO.getPageSize(), count));
        }
        Integer pageNo = industryCaseQO.getPageNo();
        industryCaseQO.buildCurrentPage();
        List<IndustryNewsDO> industryNewsDOList = industryNewsDao.listNewsPage(industryCaseQO);
        List<IndustryNewsVO> industryNewsVOS = industryNewsDOList.stream().map(IndustryNewsDO::buildIndustryNewsVO).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, industryCaseQO.getPageSize(), count, industryNewsVOS));
    }

    @Override
    public ResultBody details(Integer id) {
        IndustryNewsDO industryNewsDO = industryNewsDao.details(id);
        if (industryNewsDO!= null) {
            return ResultBody.success(industryNewsDO.buildIndustryNewsVO());
        }
        return ResultBody.success();
    }
}
