package com.mmc.csf.release.dao;

import com.mmc.csf.infomation.qo.IndustryCaseQO;
import com.mmc.csf.release.entity.TenderApplyDO;
import com.mmc.csf.release.entity.TenderInfoDO;
import com.mmc.csf.release.entity.TenderNewsDO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * author:zhenjie
 * Date:2022/5/21
 * time:17:10
 */
@Mapper
public interface TenderDao {
    void addTenderNewsDO(TenderNewsDO tenderNewsDO);

    void batchAddTenderInfo(List<TenderInfoDO> tenderInfoDOList);

    int countListTenderNews(String tenderName, Date startTime, Date endTime, Integer using);

    List<TenderNewsDO> listTenderNews(int itemIndex, Integer pageSize, String tenderName, Date startTime, Date endTime, Integer using);

    void batchRemoveTenderInfo(Integer tenderNewsId);

    void updateTenderNews(TenderNewsDO tenderNewsDO);

    void removeTenderNews(Integer id);

    int countListTenderInfo(Integer tenderNewsId);

    List<TenderInfoDO> listTenderInfo(int itemIndex, Integer pageSize, Integer tenderNewsId);

    void updateTenderInfo(@Param("id") Integer id, @Param("tenderTitle") String tenderTitle, @Param("tenderPrice") BigDecimal tenderPrice, @Param("tenderContent") String tenderContent);

    TenderApplyDO getTenderApplyByUId(Integer userAccountId, Integer tenderInfoId);

    void addTenderApply(TenderApplyDO tenderApplyDO);

    int countListTenderApply(Integer tenderNewsId, Integer tenderInfoId, String keyword);

    List<TenderApplyDO> listTenderApply(int itemIndex, Integer pageSize, Integer tenderNewsId, Integer tenderInfoId, String keyword);

    List<TenderApplyDO> listAppTenderApply(Integer tenderNewsId, Integer userAccountId);

    TenderNewsDO latestTenderNewsDO();

    int countListTenderInfoApp(Integer tenderNewsId);

    List<TenderInfoDO> listTenderInfoApp(int itemIndex, Integer pageSize, Integer tenderNewsId);

    int countExistSameName(Integer id, String tenderName);

    int countNewListTenderInfo(IndustryCaseQO industryCaseQO);

    List<TenderInfoDO> listNewListTenderInfo(IndustryCaseQO industryCaseQO);

    List<Integer> listApplyTenderInfoIds(List<Integer> tenderInfoIds, Integer applyUserId);
}
