package com.mmc.csf.release.flyer.vo;

import com.mmc.csf.release.model.group.Create;
import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @Author small
 * @Date 2023/5/23 14:14
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
//@ApiModel(value = "com.mmc.csf.model.vo.ModuleInfoVO", description = "宣传中心模块VO")
public class ModuleInfoVO implements Serializable {
    private static final long serialVersionUID = 8806759177487648665L;
    @ApiModelProperty(value = "模块id")
    @NotNull(message = "id不能为空", groups = { Update.class})
    private Integer id;
    @ApiModelProperty(value = "模块名称")
    @Size(max = 70, message = "模块名称不能超过70个字符", groups = { Create.class, Update.class })
    private String moduleName;
    @ApiModelProperty(value = "所属产品")
    private Integer moduleType;
    @ApiModelProperty(value = "code")
    @NotEmpty(message = "moduleCode不能为空", groups = { Create.class, Update.class })
    @Size(max = 15, message = "moduleCode不能超过15个字符", groups = { Create.class, Update.class })
    private String moduleCode;
    @ApiModelProperty(value = "备注")
    private String remark;
}
