package com.mmc.csf.infomation.vo;

import com.mmc.csf.release.model.group.Update;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class TenderInfoVO  implements Serializable {
    private static final long serialVersionUID = -8188835029420792396L;
    @NotNull(message = "修改时id不能为空",groups = Update.class)
    private Integer id;

    @ApiModelProperty(value = "招标快讯标题")
    @Length(message = "修改标题不能超过64字符",max = 64,groups = Update.class)
    @NotBlank(message = "修改时标题不能为空",groups = Update.class)
    private String tenderTitle;

    @ApiModelProperty(value = "价格")
    private BigDecimal tenderPrice;

    @ApiModelProperty(value = "招标快讯内容")
    private String tenderContent;
}
