import { FC, useEffect, useState } from 'react';
import { Button, Modal, ModalProps, Table } from 'antd';
import { FlyerCenterAPI } from '~/api';
import { getAbilityListType, selectPilotListByTeamType } from '~/api/interface/flyerCenterType';
import { InterDataType, InterListType } from '~/api/interface';
import { ColumnsType } from 'antd/es/table';
import AddFlyerSkillModal from '~/pages/flyerManage/flyerTeam/comp/addFlyerSkillModal';
import { PlusOutlined } from '@ant-design/icons';

//飞手列表返回类型
type getAbilityList = InterDataType<getAbilityListType>;
// 列表的类型
type TableType = InterListType<selectPilotListByTeamType>;
interface selfProps {
  onCancel: () => void;
  flyerItem: TableType[0] | undefined;
}
const UpdateFlyerSkillModel: FC<ModalProps & selfProps> = ({ open, onCancel, flyerItem }) => {
  const [pilotSkill, setPilotSkill] = useState<getAbilityList>([]);

  const [addFlyerSkillShow, setAddFlyerSkillShow] = useState<boolean>(false);

  const [userId, setUserId] = useState<number>(0);

  const [pilotSkillInfo, setPilotSkillInfo] = useState<getAbilityList[0]>();
  const handleOk = () => {
    FlyerCenterAPI.updatePilotAbility({
      userId: flyerItem?.userAccountId,
      state: 1,
    }).then((res) => {
      if (res && res.code === '200') {
        onCancel?.();
      }
    });
  };

  //获取飞手技能认证过的
  const getPilotSecondAbilityList = () => {
    FlyerCenterAPI.selectInspectionAbility({
      userId: flyerItem?.userAccountId,
      state: 1,
    }).then((res) => {
      if (res.code === '200') {
        setPilotSkill(res.result);
      }
    });
  };
  const handleDelete = (record: getAbilityList[0]) => {
    // console.log(record);
    FlyerCenterAPI.deleteAbilityById({
      id: record.id,
    }).then((res) => {
      if (res.code === '200') {
        getPilotSecondAbilityList();
      }
    });
  };
  const updatePilotSkill = (record: getAbilityList[0]) => {
    setPilotSkillInfo(record);
    setAddFlyerSkillShow(true);
  };

  useEffect(() => {
    if (flyerItem) {
      setUserId(flyerItem?.userAccountId);
      getPilotSecondAbilityList();
    }
  }, [flyerItem]);

  const columns: ColumnsType<getAbilityList[0]> = [
    {
      title: '技能名称',
      align: 'center',
      dataIndex: 'otherAbility',
    },
    {
      title: '操作',
      align: 'center',
      width: 200,
      render: (_text, record) => (
        <>
          <Button
            type='link'
            disabled={!!record.inspectionId}
            onClick={() => updatePilotSkill(record)}
          >
            修改
          </Button>
          <Button type='link' danger={true} onClick={() => handleDelete(record)}>
            删除
          </Button>
        </>
      ),
    },
  ];
  return (
    <>
      <Modal
        title={'飞手技能'}
        open={open}
        onOk={handleOk}
        onCancel={onCancel}
        width={'500px'}
        centered={true}
      >
        <Button icon={<PlusOutlined />} type={'primary'} onClick={() => setAddFlyerSkillShow(true)}>
          添加飞手技能
        </Button>
        <Table
          size='small'
          dataSource={pilotSkill}
          columns={columns}
          rowKey='id'
          // scroll={{ x: 1000 }}
          bordered
        />
      </Modal>
      <AddFlyerSkillModal
        open={addFlyerSkillShow}
        onCancel={() => {
          setAddFlyerSkillShow(false);
          getPilotSecondAbilityList();
        }}
        pilotSkillInfo={pilotSkillInfo}
        userId={userId}
      />
    </>
  );
};

export default UpdateFlyerSkillModel;
