import { FC, useEffect } from 'react';
import { Form, Input, Modal, ModalProps } from 'antd';
import { getAbilityListType } from '~/api/interface/flyerCenterType';
import { InterDataType } from '~/api/interface';
import { FlyerCenterAPI } from '~/api';
//飞手列表返回类型
type getAbilityList = InterDataType<getAbilityListType>;
interface selfProps {
  onCancel: () => void;
  pilotSkillInfo: getAbilityList[0] | undefined;
  userId: number;
}
const AddFlyerSkillModal: FC<ModalProps & selfProps> = ({
  open,
  onCancel,
  pilotSkillInfo,
  userId,
}) => {
  const [formRef] = Form.useForm();
  const handleOk = () => {
    formRef.validateFields().then(async (val) => {
      const res = await FlyerCenterAPI[
        pilotSkillInfo?.id ? 'updateByIdAndOtherAbility' : 'insertByOtherAbility'
      ]({
        id: pilotSkillInfo?.id,
        otherAbility: val?.skillName,
        userId: userId,
      });
      if (res && res.code === '200') {
        onCancel?.();
      }
    });
  };

  useEffect(() => {
    if (!pilotSkillInfo?.id) return;
    formRef.setFieldValue('skillName', pilotSkillInfo?.otherAbility);
  }, [open]);
  return (
    <Modal
      title={pilotSkillInfo?.id ? '修改飞手技能' : '添加飞手技能'}
      open={open}
      onOk={handleOk}
      onCancel={onCancel}
      width={'500px'}
      centered={true}
    >
      <Form form={formRef} autoComplete={'off'}>
        <Form.Item
          label={pilotSkillInfo?.id ? '当前技能名称：' : '请输入技能名称：'}
          name={'skillName'}
          rules={[{ required: true, message: '请输入技能名称' }]}
        >
          <Input
            type='text'
            id='skillName'
            placeholder={pilotSkillInfo?.id ? '点击修改...' : '输入技能名称'}
            maxLength={10}
          />
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default AddFlyerSkillModal;
